//
//  SingletonTimer.swift
//  Orbis
//
//  Created by Shiri Ganesh on 8/22/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit

class SingletonTimer: NSObject {
    
    
    static let sharedInstance = SingletonTimer()
    

    
    var every30sTimer = Timer()

    var totaltime = 90
 
    func start30SecTimer() {
        
        every30sTimer = Timer.scheduledTimer(withTimeInterval: 30, repeats: true, block: { (timer) in
            
            
            if appDelegate.scheduler.isValid{
                Globals().createNotification(title: "Amber Alert", message: "\(self.totaltime) seconds left to activate!")
                self.totaltime = self.totaltime - 30

            }else{
                self.totaltime = 90

                Globals().createNotification(title: "Red Alert", message: "Red alert activated!")
                
            }

        })
    }
    
    
    func stop30SecTimer() {
        self.totaltime = 90
      every30sTimer.invalidate()
    }

}
